-- Weather Underground to Apple //
-- 2011 Kevin Dady
--  
-- Radar processing:
-- feed jpeg to image magick
-- phrase output.xpm to color tables
-- package for apple // 
-- send radar

radar = {}

	radar.data = {}
		radar.data.input  = {}  -- raw file data table dump
		radar.data.packed = {}  -- packed apple data
		radar.data.apl2 = {{},{},{},{},{},{}} -- black, green, violet, orange, blue, white 

	radar.img = {}
		radar.img.header = 11 -- xpm file header # of lines
		radar.img.w = 141 
		radar.img.h = 141

radar.convertIMG = function()
  
	cmd.imageMGK(" temp/radar.jpg -level 0%,70%,1 -dither none -map req/apple.xpm temp/output.xpm")
  -- read the file into a table
	local file = io.open("temp/output.xpm","r")
	for line in file:lines() do
		table.insert(radar.data.input, tostring(line))
	end
	file:close()

	-- remove header
	for i = 1, radar.img.header do -- hardcode
		table.remove(radar.data.input, 1)
	end

	-- remove footer
	table.remove(radar.data.input, radar.img.w)

  -- remove non color data
	for i = 1, #radar.data.input do
		radar.data.input[i] = string.sub(radar.data.input[i], 2, radar.img.h)
	end

	-- !! EDIT !!
	-->	
	-- only deal with odd rows, due to the even / odd, bit / line, funny way apple 2's display highres colors.
	-- if we leave them all in the image there is a gret chance of 2 colors phasing into another,
  -- since we are going to loose pixel resolution anyway, we can cut that down some by deleting every other line
  -- giving 140x70 also making transfer size smaller.
  -- <--
	local keep ={}
	for i = 1, #radar.data.input do
		if (i % 2) == 1 then table.insert(keep, radar.data.input[i]) end			
	end		
	radar.data.input = keep
end

-- " " = 0 Apple color black (1)
-- "X" = 1 Apple color green
-- "o" = 2 Apple color violet
-- "." = 5 Apple color orange
-- "O" = 6 Apple color blue
-- "+" = 7 Apple color white (2)

radar.sortIMG = function()
	local newChar = ""	
	-- need to convert the strings into tables
	for y = 1, #radar.data.input do
		-- add a new "line" string to each color table
		for color = 1, 6 do
			table.insert(radar.data.apl2[color], {})
		end
		-- for each column in the current row
		for x = 1, #radar.data.input[y] do
			-- read the character at that Y,X point
			newChar = string.sub(radar.data.input[y], x,x)	
			-- assign each character a individual table value
			if newChar == " " then table.insert(radar.data.apl2[1][y], x) -- black
				elseif newChar == "X" then table.insert(radar.data.apl2[4][y], x) -- GREEN
				elseif newChar == "o" then table.insert(radar.data.apl2[3][y], x) -- violet
				elseif newChar == "." then table.insert(radar.data.apl2[2][y], x) -- ORANGE
				elseif newChar == "O" then table.insert(radar.data.apl2[5][y], x) -- blue
				elseif newChar == "+" then table.insert(radar.data.apl2[6][y], x) -- white
			end
		end
	end 
end

radar.packageIMG = function()	
  for color = 1, 5 do	-- ignore white, white takes a long time to draw since it makes up most of the graphic
		for y = 1, #radar.data.apl2[color] do
			local one   = ""
			local two   = ""
			local three = ""
			local four  = ""
			for x = 1, #radar.data.apl2[color][y] do
				if radar.data.apl2[color][y][x] <= 35 then
						one = one .. string.sub(graphicsKey, radar.data.apl2[color][y][x], radar.data.apl2[color][y][x])
				elseif radar.data.apl2[color][y][x] <= 70 then
						two = two .. string.sub(graphicsKey, radar.data.apl2[color][y][x] - 35, radar.data.apl2[color][y][x] - 35)
				elseif radar.data.apl2[color][y][x] <= 105 then
						three = three .. string.sub(graphicsKey, radar.data.apl2[color][y][x] - 70, radar.data.apl2[color][y][x] - 70)
				else
						four = four .. string.sub(graphicsKey, radar.data.apl2[color][y][x] - 105, radar.data.apl2[color][y][x] - 105)
				end
			end

			if one == "" and two == "" and three == "" and four == "" then
				table.insert(radar.data.packed, "n")
			else table.insert(radar.data.packed,one.."b"..two.."b"..three.."b"..four)
			end
		end
	end
end

radar.send = function()
	for line = 1, 350 do
		cmd.sjinn(radar.data.packed[line])
	end
end





